<?php
require_once 'config.php';
require_once 'ibs/functions.php';

//------------- Keyboards -------------------//

function new_user(): bool
{

    $stmnt = db->prepare("SELECT * FROM step where telegram_id=?");
    $stmnt->bindValue(1, chat_id);
    $stmnt->execute();

    $rows = $stmnt->rowCount();
    if ($rows == 0) {
        return TRUE;
    }
    else {
        return FALSE;
    }
}

function add_step(): void
{

    $stmnt = db->prepare("INSERT INTO `step`(`telegram_id`, `step`) VALUES (?,?)");
    $stmnt->bindValue(1, chat_id);
    $stmnt->bindValue(2, "wlc");
    $stmnt->execute();
}

function wlc_message(): void
{

    sendMessage("سلام دوست عزیز 7️⃣\nدرصورتی که کاربر فعلی مجموعه 7vpn هستید، برای استفاده از امکانات ویژه ربات (تخفیف های شخصی، اطلاع رسانی پایان اعتبار و...) لطفا گزینه ورود با نام کاربری را انتخاب کنید.\nدرغیر اینصورت لطفا گزینه ورود بدون نام کاربری را انتخاب کنید.\nبا تشکر🙏🏻\n",
        "login");
}

function ios(): void
{
    bot->sendVideo(
        [
            'chat_id' => chat_id,
            'video' => new CURLFILE(realpath("video/ios.mp4")),
            'caption' => "ویدیو آموزشی",
        ]
    );
    sendMessage("https://apps.apple.com/us/app/openvpn-connect-openvpn-app/id590379981");
    open_profile();
}

function android(): void
{

    sendMessage("درحال ارسال...🚛");

    $appFolder = __DIR__ . '/apps/';
    $apkFiles = glob($appFolder . '*.apk');

    foreach ($apkFiles as $filePath) {
        $fileName = basename($filePath);

        if (stripos($fileName, 'v8a') !== false) {
            $caption = 'نرم‌افزار اختصاصی اندروید برای گوشی‌های arm64-v8a' . "\n" . '۹۰٪ گوشی‌های اندروید جدید';
        } elseif (stripos($fileName, 'v7a') !== false) {
            $caption = 'نرم‌افزار اختصاصی اندروید برای گوشی‌های armeabi-v7a' . "\n" . '۱۰٪ گوشی‌های اندروید';
        } else {
            // If unknown architecture, use generic caption
            $caption = 'فایل نصب اندروید';
        }

        bot->sendDocument([
            'chat_id' => chat_id,
            'document' => new CURLFile(realpath($filePath)),
            'caption' => $caption
        ]);
    }
}

function windows(): void
{
    sendMessage("درحال ارسال...🚛");

    $matches = glob("apps/7vpn-*.zip");

    if (!empty($matches)) {
        $filePath = realpath($matches[0]);

        bot->sendDocument([
            'chat_id' => chat_id,
            'document' => new CURLFile($filePath),
            'caption' => 'نرم افزار اختصاصی ویندوز'
        ]);
    } else {
        sendMessage("فایل 7vpn یافت نشد ❌");
    }
}

function open_profile(): void
{
    $folderPath = 'profile/Hamrah/';
    $folderPath2 = 'profile/Irancell/';

    bot->sendMessage(
        [
            'chat_id' => chat_id,
            'text' => "پروفایل های همراه اول و ایرانسل",
        ]
    );
    $files = scandir($folderPath);
    $files2 = scandir($folderPath2);
    foreach ($files as $file) {
        // Skip directories and hidden files.
        if (is_dir($folderPath . $file) || str_starts_with($file, '.')) {
            continue;
        }
        // Set the file path.
        $filePath = $folderPath . $file;

        // Prepare the cURL request.
        bot->sendDocument(
            [
                'chat_id' => chat_id,
                'document' => new CURLFile($filePath),
            ]
        );
    }
    bot->sendMessage(
        [
            'chat_id' => chat_id,
            'text' => "پروفایل های مخصوص ایرانسل و اینترنت های WI-FI",
        ]
    );
    foreach ($files2 as $file) {
        // Skip directories and hidden files.
        if (is_dir($folderPath2 . $file) || str_starts_with($file, '.')) {
            continue;
        }
        // Set the file path.
        $filePath2 = $folderPath2 . $file;

        // Prepare the cURL request.
        bot->sendDocument(
            [
                'chat_id' => chat_id,
                'document' => new CURLFile($filePath2),
            ]
        );
    }

}

function cisco_server(): void
{

    bot->sendmessage(
        [
            'chat_id' => chat_id,
            'text' => "لیست سرور ها به صورت مستقیم برای نرم افزار OpenConnect:\n
  فنلاند1:
  95.217.14.151:4433
  فنلاند2:
  95.217.212.121:4433
  فنلاند3:
  65.108.240.43:4433
  فنلاند4:
  95.216.162.224:4433
  فنلاند5:
  65.109.160.225:4433
  آمریکا:
  5.161.156.140:4433
  هلند:
  109.207.173.52:4433
  "
        ]
    );
}

function contact_us(): void
{


    bot->sendmessage(
        [
            'chat_id' => chat_id,
            'text' => "برای خرید، تمدید، مشاوره و رفع مشکلات با پشتیبانی در ارتباط باشید.\n
  آدرس سایت : 7vpn.site\n
  کانال تلگرام : @s7vpn\n
  ارتباط با پشتیبانی : @se7en_vpn\n"
        ]
    );
}

function get_username(): void
{

    sendMessage("لطفا نام کاربری خود را وارد کنید", "remove");
}

function home(): void
{

    if (is_loged())
        sendMessage("درصورت نیاز برای خرید اکانت و پشتیبانی به ما پیام دهید\n@se7en_vpn", "loged_user");
    else
        sendMessage("درصورت نیاز برای خرید اکانت و پشتیبانی به ما پیام دهید\n@se7en_vpn", "not_loged_user");
}

function skip_login(): void
{
    global $username;
    addtotelegram_ibs(chat_id, $username, "not loged");
    home();
}

function login(): void
{

    sendMessage("لطفا یکی از گزیه هارا انتخاب کنید\nبا تشکر🙏🏻\n", "login");
}

function insert_username(): void
{
    global $text;
    if (preg_match('/[\'^£$%&*()}{@#~?><,|=+¬-]/', $text)) {
        bot->sendmessage(
            [
                'chat_id' => chat_id,
                'text' => "نام کاربری اشتباه است، لطفا دوباره و صحیح نام کاربری را وارد کنید"
            ]
        );
    }
    else if (preg_match(('/^te\d{4}$/'), $text)) {
        Setstep("wlc");
        sendMessage("ورود با اکانت تست ممکن نیست، برای دریافت آموزش ها لطفا دکمه ورود بدون نام کاربری را بزنید", "login");
    }
    else {
        Setstep("login_pswd");
        add_to_auth();
        sendMessage("لطفا پسورد خود را وارد کنید", NULL);
    }
}

function check_auth(): void
{
    global $username;
    add_to_auth();
    $response = get_user_pass();
    if (check_ibs_auth($response[0]['ibs_username'], $response[0]['ibs_password'])) {
        delete_auth();
        delete_from_ibs_telegram("not loged");
        if (check_login()) {
            addtotelegram_ibs(chat_id, $username, $response[0]['ibs_username']);
            sendMessage("اکانت مورد نظر اضافه شد.", NULL);
            Setstep("mng");
            mng();
            return;
        }
        $ibs_username = $response[0]['ibs_username'];

        $ibs_user_id = get_user_id($ibs_username);
        $today = date("Y-m-d");
        $timestamp1 = strtotime($today);
        $timestamp2 = strtotime(check_exp($ibs_user_id));
        $diffInSeconds = ($timestamp2 - $timestamp1);
        $days = floor($diffInSeconds / (60 * 60 * 24));

        if ($days <= 0) {
            sendMessage("اعتبار اکانت شما تمام شده به همین دلیل قادر به ورود با نام کاربری نیستید، درصورت نیاز به آموزش ها از دکمه ورود بدون نام کاربری استفاده کنید", "login");
            Setstep("wlc");
            return;
        }
        addtotelegram_ibs(chat_id, $username, $response[0]['ibs_username']);
        Setstep("referral");
        sendMessage("ثبت شد خوش آمدید\n آیا مایل ثبت معرف خود هستید؟", "yes_no");
    }
    else if (check_login()) {
        sendMessage("ترکیب نام کاربری و پسورد شما درست نیست", NULL);
        delete_auth();
        Setstep("mng");
        mng();
        return;
    }
    else {
        sendMessage("ترکیب نام کاربری و پسورد شما درست نیست", NULL);
        delete_auth();
        Setstep('wlc');
        login();
    }
}

function user_show_menu(): void
{

    if (is_loged())
        sendMessage("انتخاب کنید", "loged_user");
    else
        sendMessage("انتخاب کنید", "not_loged_user");

}

function admin_show_menu(): void
{
    sendMessage("مدیریت", "admin");
}

function show_amozesh_menu(): void
{

    sendMessage("انتخاب کنید", "amozesh");
}

function mng(): void
{


    $results = users();

    $keys = [];
    foreach ($results as $result) {
        $keys[] = ['text' => $result, 'callback_data' => "delete-" . $result];
    }

    $keys[] = ['text' => "بازگشت به منو اصلی", 'callback_data' => 'بازگشت'];
    $keys[] = ['text' => "افزودن اکانت جدید", 'callback_data' => 'افزودن'];

    $keys = array_chunk($keys, 3);

    sendMessage("لیست اکانت های ثبت شده با آی دی تلگرام شما در پایین نمایش داده شده است \n\n درصورتی که مایل به حذف هر یک از اکانت ها هستید باید روی نام کاربری مورد نظر کلیک کنید و به صورت خودکار اتصال این نام کاربری با تلگرام شما از بین خواهد رفت (عدم دریافت اطلاعیه های پایان اعتبار و تخفیف ها)\n\n درصورتی که مایل هستید اکانت دیگری را به تلگرام خود اضافه کنید روی گزینه افزودن کلیک کنید", "remove");

    bot->sendmessage([
        "chat_id" => chat_id,
        "text" => "مدیریت اکانت ها",
        'reply_markup' => json_encode(['inline_keyboard' => $keys, 'remove_keyboard' => TRUE]),
    ]);
}

function feedback()
{
    sendMessage("با تشکر از احساس مسئولیت شما، وجود شما در مجموعه ما باعث افتخار ما هست، پیام شما مستقیما برای مدیریت مجموعه ارسال خواهد شد.", "cancel");
}

function mng_del(): void
{

    sendMessage("اکانت مورد نظر حذف شد\nانتخاب کنید!", "loged_user");
}

function mng_add_new(): void
{

    sendMessage("اکانت مورد نظر اضافه شد\nانتخاب کنید!", "loged_user");
}

function test_acc(): void
{

    $stmnt = db->query("SELECT user, pass, register_time FROM test_acc");
    $result = $stmnt->fetch(PDO::FETCH_ASSOC);
    $inputTimestamp = strtotime($result['register_time']) - 12600;
    $currentTimestamp = time();
    $timeDifference = $currentTimestamp - $inputTimestamp;


    if ($timeDifference < 86400) {
        $remainTime = round((86400 - $timeDifference) / 3600);
        sendMessage("نام کاربری: " . $result['user'] . " \nپسورد: " . $result['pass'] . "\n" . "اعتبار : " .$remainTime . " ساعت", "admin");
    }
    else {
        $rand_user = "te" . sprintf("%04d", rand(0, 9999));
        $rand_pass = sprintf("%04d", rand(0, 9999));

        $stmnt = db->prepare("UPDATE test_acc SET user = :rand_user, pass = :rand_pass, register_time = NOW() WHERE id = 1");
        $stmnt->bindParam(':rand_user', $rand_user);
        $stmnt->bindParam(':rand_pass', $rand_pass);
        $stmnt->execute();

        $user_id = "620";
        pg_query(conn, "UPDATE user_attrs SET attr_value=extract(epoch FROM now())::INTEGER WHERE user_id=$user_id and attr_name='first_login'");
        pg_query(conn, "UPDATE normal_users SET normal_username='$rand_user',normal_password='$rand_pass' WHERE user_id=$user_id");
        sendMessage("نام کاربری: $rand_user \nپسورد: $rand_pass", "admin");
    }
}

function set_referral(string $text): void
{


    $ibs_username = get_ibs_username();
    $ibs_username = $ibs_username[0]['ibs_username'];

    if ($ibs_username == $text) {
        sendMessage("شما نمی توانید معرف خود باشید", NULL);
        home();
        Setstep('home');
        return;
    }
    try {
        $stmnt = db->prepare("select * from telegram_ibs where CAST(`ibs_username` AS BINARY)=?");
        $stmnt->bindValue(1, $text);
        $stmnt->execute();
        $query = get_query($stmnt);
    } catch (PDOException $e) {
        send_log($e, get_query($stmnt));

    }
    if ($stmnt->rowCount() < "1") {
        sendMessage("نام کاربری وارد شده در ربات ما ثبت نشده، مایل به وارد کردن دوباره هستید؟", "yes_no");
        Setstep("referral");
        return;
    }
    try {
        $stmnt = db->prepare("SELECT * from referral where ibs_username=?");
        $stmnt->bindValue(1, $text);
        $stmnt->execute();
        $query = get_query($stmnt);
    } catch (PDOException $e) {
        send_log($e, get_query($stmnt));

    }
    if ($stmnt->rowCount() < "1") {
        try {
            $stmnt = db->prepare("insert into referral (`ibs_username`,`referral_list`,`count`) values (?,?,?)");
            $stmnt->bindValue(1, $text);
            $stmnt->bindValue(2, "$ibs_username-");
            $stmnt->bindValue(3, 1);
            $stmnt->execute();
            $query = get_query($stmnt);
            home();
            Setstep('home');
            return;
        } catch (PDOException $e) {
            send_log($e, get_query($stmnt));

        }
    }
    try {
        $stmnt = db->prepare("select `count`,`referral_list` from referral where `ibs_username`=?");
        $stmnt->bindValue(1, $text);
        $stmnt->execute();
        $query = get_query($stmnt);

        $fetch = $stmnt->fetchAll(PDO::FETCH_ASSOC);
        $currentCount = $fetch[0]['count'];
        $newCount = $currentCount + 1;
        $list = $fetch[0]['referral_list'];
        $list = rtrim($list, '-');
        $list = explode('-', $list);
        if (!in_array($ibs_username, $list)) {
            $list[] = "$ibs_username-";
            $list = implode('-', $list);
            $stmnt = db->prepare("update `referral` set `count`=?,`referral_list`=? where ibs_username=?");
            $stmnt->bindParam(1, $newCount);
            $stmnt->bindParam(2, $list);
            $stmnt->bindParam(3, $text);
            $stmnt->execute();
            $query = get_query($stmnt);
            home();
            Setstep('home');
            return;
        }
        sendMessage("شما قبلا این کاربر را به عنوان معرف خود اعلام کرده اید!", NULL);
        home();
        Setstep('home');
        return;
    } catch (PDOException $e) {
        send_log($e, get_query($stmnt));

    }
    home();
    Setstep('home');
}

function show_referral(): void
{

    $user = get_ibs_username();
    $user = $user[0];
    if (count($user) == 1) {
        $count = get_referral_count($user);
        if ($count < referral_threshold) {
            sendMessage("تعداد زیر مجموعه های شما کمتر از 3 کاربر است به همین دلیل قادر به استفاده از امتیاز های خود نیستید." . "\n\n" . "تعداد زیر مجموعه شما:" . $count, "loged_user");
        }
        else {
            Setstep("use_referral");

            $keys = [];
            $keys[] = ['text' => "استفاده از امتیاز", 'callback_data' => "use_referral-{$user['ibs_username']}"];
            $keys[] = ['text' => "بازگشت به منو اصلی", 'callback_data' => 'بازگشت'];

            $keys = array_chunk($keys, 2);
            sendMessage("تبریک شما میتوانید از امتیاز های خود استفاده کنید. هر سه کاربر معرفی شده از طرف شما یک ماه شارژ رایگان برای شما دارد\n\nدر حال حاضر امتیاز شما:$count", "remove");
            bot->sendmessage([
                "chat_id" => chat_id,
                "text" => "برای استفاده از امتیاز خود فقط کافی است روی دکمه استفاده از امتیاز کلیک کنید.",
                "reply_markup" => json_encode(['inline_keyboard' => $keys]),
            ]);
        }
    }
    else {
        $user_list = "";
        $keys = [];
        $pass_threshold = FALSE;
        foreach ($user as $usr) {
            $count = get_referral_count($usr);
            if ($count > referral_threshold) {
                $pass_threshold = TRUE;
                $keys[] = ['text' => "استفاده از امتیاز اکانت : {$usr['ibs_username']} - امتیاز اکانت: $count", 'callback_data' => "use_referral-{$usr['ibs_username']}"];
            }
            else {
                $user_list = $user_list . "اکانت: {$usr['ibs_username']} ------امتیاز: $count" . "\n";
            }
        }
        if (!$pass_threshold) {
            sendMessage("تعداد زیر مجموعه های شما کمتر از 3 کاربر است به همین دلیل قادر به استفاده از امتیاز های خود نیستید." . "\n\n" . "تعداد زیر مجموعه شما:\n\n" . $user_list, "loged_user");
            return;
        }
        sendMessage("تبریک شما میتوانید از امتیاز های خود استفاده کنید. هر سه کاربر معرفی شده از طرف شما یک ماه شارژ رایگان برای شما دارد", "remove");
        $keys[] = ['text' => "بازگشت به منو اصلی", 'callback_data' => 'بازگشت'];
        $keys = array_chunk($keys, 1);
        if ($user_list == "") {
            $user_list = "اکانت دیگری موجود نیست";
        }
        bot->sendmessage([
            "chat_id" => chat_id,
            "text" => "برای استفاده از امتیاز هر اکانت روی آن اکانت کلیک کنید" . "\n\n" . "مابقی اکانت های شما:" . "\n\n" . $user_list,
            'reply_markup' => json_encode(['inline_keyboard' => $keys, 'remove_keyboard' => TRUE]),
        ]);
        Setstep("use_referral");
    }
}

function use_referral(string $user): void
{

    try {
        $stmnt = db->prepare("select `count` from referral where CAST(`ibs_username` AS BINARY)=?");
        $stmnt->bindValue(1, $user);
        $stmnt->execute();
        $query = get_query($stmnt);
        $count = $stmnt->fetchColumn();
    } catch (PDOException $e) {
        send_log($e, get_query($stmnt));
    }
    try {
        $stmnt = db->prepare("UPDATE referral SET `count`=? where CAST(`ibs_username` AS BINARY)=?");
        $stmnt->bindValue(1, $count - 3);
        $stmnt->bindValue(2, $user);
        $stmnt->execute();
        $query = get_query($stmnt);

    } catch (PDOException $e) {
        send_log($e, get_query($stmnt));

    }
    Add_Users_EXP($user, 30);
    Setstep("home");
    sendMessage("یک ماه اعتبار حساب رایگان برای اکانت $user اعمال شد، ممکن است اضافه شدن مدت اعتبار کمی زمان بر باشد.", "loged_user");
}

function get_referral_count($user)
{

    $user = $user['ibs_username'];
    try {
        $stmnt = db->prepare("select `count` from referral where CAST(`ibs_username` AS BINARY)=?");
        $stmnt->bindValue(1, $user);
        $stmnt->execute();
        $query = get_query($stmnt);
    } catch (PDOException $e) {
        send_log($e, get_query($stmnt));
    }
    $count = $stmnt->fetchColumn();
    var_dump($count);
    if (!$count)
        $count = "0";
    return $count;
}

function delete_from_ibs_telegram(string $username = ""): void
{

    try {
        $stmnt = db->prepare("delete from telegram_ibs where `telegram_id`=? and `ibs_username`=?");
        $stmnt->bindValue(1, chat_id);
        $stmnt->bindValue(2, $username);
        $stmnt->execute();
        $query = get_query($stmnt);
    } catch (PDOException $e) {
        send_log($e, get_query($stmnt));
    }
}

function reset_user($user): void
{
    try {
        $stmnt = db->prepare("DELETE FROM step WHERE `telegram_id`=?");
        $stmnt->bindValue(1, $user);
        $stmnt->execute();
    } catch (PDOException) {
    }
    try {
        $stmnt = db->prepare("DELETE FROM auth WHERE `telegram_id`=?");
        $stmnt->bindValue(1, $user);
        $stmnt->execute();

    } catch (PDOException) {
    }
    try {
        $stmnt = db->prepare("DELETE FROM telegram_ibs WHERE `telegram_id`=?");
        $stmnt->bindValue(1, $user);
        $stmnt->execute();
    } catch (PDOException) {
    }

}

function isChannelMember(): bool
{
    $response = bot->getChatMember(
        [
            'chat_id' => '-1001222450242',
            'user_id' => chat_id
        ]
    );
    if ($response['result']['status'] == "member" or $response['result']['status'] == "creator" or $response['result']['status'] == "administrator") {
        return TRUE;
    }
    else {
        return FALSE;
    }
}

function forwardMessage($toChatId, $messageId = "", $fromChatId = chat_id)
{
    global $message_id;
    if ($messageId == "")
        $messageId = $message_id;
    return bot->forwardMessage(
        [
            'chat_id' => $toChatId,
            'from_chat_id' => $fromChatId,
            'message_id' => $messageId
        ]
    );
}

function forwardMessageToAmin(): void
{
    global $text, $message_id;
    $stmnt = db->prepare("INSERT INTO `user_tmp`(`name`, `value`) VALUES (?,?)");
    $stmnt->bindValue(1, $text);
    $stmnt->bindValue(2, $message_id);
    $stmnt->execute();
    Setstep('home');
    forwardMessage(toChatId: ADMIN['mahdi']);
    sendMessage("با تشکر، پیام شما ارسال شد");
}

function adminReplyToFeedBack()
{

    $messageId = selectFromDB("user_tmp", ["value"], "name='" .
        replyToMessageFromUserIDMessage . "'")[0]['value'];
    deleteFromDB("user_tmp", "name='" . replyToMessageFromUserIDMessage . "'");
    return $messageId;
}

function selectFromDB($table, $columns, $condition = NULL): false|array|string
{
    // $selectedValues = selectFromDB("admins", ["*"],"id=4");
    // $selectedValues = selectFromDB("admins", ["telegram_id","telegram_username"],"id=4");
    $columns = implode(',', $columns);
    if (is_null($condition)) {
        $sql = "SELECT $columns FROM $table";
    }
    else {
        $sql = "SELECT $columns FROM $table WHERE $condition";
    }
    $stmt = db->prepare($sql);
    try {
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        return "";
    }
}

function deleteFromDB($table, $condition)
{
// deleteFromDB("admins","id=4");

    $sql = "DELETE FROM $table WHERE $condition";
    $stmt = db->prepare($sql);
    try {
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        return "";
    }
}

function getUserDevice($user,$isEdit = false)
{
    $data = file_get_contents("https://api.app7app.ir/api.php?APIKEY=0c8ac86b-7712-4cd1-94bc-a7c6b12df4c7&ACTION=DEVICELIST&user=$user");
    $data = json_decode($data, true);
    $devices = explode("&&", $data['ListDevice']);

    $keyboard = [];
    foreach ($devices as $device)
    {
        $keyboard[] = ['text'=>$device,"callback_data" =>"delete_device/" . $device . "/$user"];
    }
    $keyboard[] = ['text'=>'همه دستگاه ها',"callback_data" =>"delete_device/all/$user"];
    $keyboard[] = ['text' => 'بازگشت', 'callback_data' => 'back'];
    $keyboard = array_chunk($keyboard, 1);
    $keyboard = ['inline_keyboard' => $keyboard];
    if ($isEdit)
    {
        editMessage(chat_id,text: "لیست دستگاه های کاربر، برای حذف هرکدام روی آن کلیک کنید", keyboardInput:  $keyboard);
    }
    else
    {
        $x = sendMessage("لیست دستگاه های کاربر، برای حذف هرکدام روی آن کلیک کنید", "custom", $keyboard);
    }
}

function deleteUserDevice($device , $user)
{
    if ($device == "all")
    {
        $data = file_get_contents("https://api.app7app.ir/api.php?APIKEY=0c8ac86b-7712-4cd1-94bc-a7c6b12df4c7&ACTION=DEVICELIST&user=$user");
        $data = json_decode($data, true);
        $devices = explode("&&", $data['ListDevice']);
        foreach ($devices as $device)
        {
            file_get_contents("https://api.app7app.ir/api.php?APIKEY=0c8ac86b-7712-4cd1-94bc-a7c6b12df4c7&ACTION=DELDEVICE&user=$user&device=$device");
        }
    }
    else
    {
        file_get_contents("https://api.app7app.ir/api.php?APIKEY=0c8ac86b-7712-4cd1-94bc-a7c6b12df4c7&ACTION=DELDEVICE&user=$user&device=$device");
    }
}
function noroz()
{
    $remain = file_get_contents("gift.txt");
    $details = selectFromDB("noroz",["*"],"telegram_id='" . chat_id ."'")[0];
    deleteUserMessage(messageId);
    if (!empty($details)) {
        sendMessage("شما قبلا شرکت کردید");
        return;
    }
    else if ($remain <= 0 )
    {
        sendMessage("متاسفانه تمام کد های تخفیف تموم شد، ولی ناراحت نباش، ما همیشه 10 درصد تخفیف برای تمدید سرویس هامون داریم");
        return;
    }
    $remain = $remain - 1;
    file_put_contents("gift.txt", $remain);
    $offers = [
        "۱۰٪ تخفیف تمدید ۶ ماهه",
        "۵۰٪ تخفیف تمدید ۱ ماهه",
        "۲۰٪ تخفیف تمدید ۳ ماهه",
        "۲۰٪ تخفیف خرید جدید",
        "۱۵٪ تخفیف تمدید همه سرویس‌ها"
    ];

    $randomCount = rand(5, 10);
    $r = sendMessage("آماده ای؟ شروع در 3 ثانیه...");
    $messageId = $r['result']['message_id'];
    $x=3;
    $orderId = 0;
    $selected = "";
    while (TRUE)
    {
        sleep(1);
        $x--;
        editMessage(messageId: $messageId, text: "آماده ای؟ شروع در $x ثانیه...");
        if ($x <= 0) break;
    }
    for ($i = 0; $i < $randomCount; $i++) {
        $selected = "`" . $offers[array_rand($offers)] . "`";
        $text = "جایزه شما : " . $selected . " نیست 😁";
        editMessage(parsMode: "MarkdownV2", messageId: $messageId, text: $text);
        sleep(1.5);
    }
    while (TRUE) {
        $orderId = mt_rand(100000, 999999);
        $order = selectFromDB("noroz", ["*"], "code='$orderId'");
        if (empty($order)) {
            $orderId = "`" . $orderId . "`";
            break;
        }
    }
    editMessage(parsMode: "MarkdownV2", messageId: $messageId, text: "تبریک جایزه شما : " . "\n" . $selected . "\n" . "کدپیگیری شما : " . $orderId . "\n" . "برای استفاده از کد تخفیف این پیام رو برای ادمین فروارد کنید");
    sendMessage(text: " جایزه جدید : " . "\n" . $selected . "\n" . "کدپیگیری شما : " . $orderId, id: ADMIN['7vpn'], parsMode: "MarkdownV2");
    $orderId = str_replace("`","",$orderId);
    $selected = str_replace("`","",$selected);
    $stmnt = db->prepare("INSERT INTO `noroz`(`telegram_id`, `code`,`gift`) VALUES (?,?,?)");
    $stmnt->bindValue(1, chat_id);
    $stmnt->bindValue(2, $orderId);
    $stmnt->bindValue(3, $selected);
    $stmnt->execute();
}

